import csv
import matplotlib.pyplot as plt

CSV_FILE = "html_report.csv"
DELIMITER = ";"

BUCKETS = [
    ("0–100 KB", 0, 100),
    ("101–400 KB", 101, 400),
    ("401–1500 KB", 401, 1500),
    ("1501–2048 KB", 1501, 2048),
    ("> 2048 KB", 2049, None),
]

# moderne, reduzierte Farbpalette
COLORS = [
    "#6C8AE4",  # soft blue
    "#4ECDC4",  # teal
    "#FFD166",  # soft yellow
    "#F4A261",  # soft orange
    "#E76F51",  # soft red
]


def classify(size_kb):
    for i, (_, mn, mx) in enumerate(BUCKETS):
        if mx is None and size_kb >= mn:
            return i
        if mx is not None and mn <= size_kb <= mx:
            return i
    return -1


counts = [0] * len(BUCKETS)
total = 0

with open(CSV_FILE, newline="", encoding="utf-8") as f:
    reader = csv.DictReader(f, delimiter=DELIMITER)
    for row in reader:
        try:
            size_kb = float(row["size_kb"])
        except:
            continue
        idx = classify(size_kb)
        if idx >= 0:
            counts[idx] += 1
            total += 1

labels = [b[0] for b in BUCKETS]

# moderner Stil
plt.style.use("default")
fig, ax = plt.subplots(figsize=(10, 5))

bars = ax.bar(labels, counts, color=COLORS, width=0.6)

# Clean look
ax.set_facecolor("#f9fafb")
fig.patch.set_facecolor("#f9fafb")

ax.spines['top'].set_visible(False)
ax.spines['right'].set_visible(False)
ax.spines['left'].set_visible(False)
ax.spines['bottom'].set_visible(False)

ax.grid(axis='y', linestyle='--', alpha=0.25)

ax.set_title("HTML-Größenverteilung (Google 2 MB Limit)", fontsize=16, weight='bold', pad=15)
ax.set_ylabel("Seiten", fontsize=11)

# Werte modern platzieren
for i, bar in enumerate(bars):
    height = bar.get_height()
    pct = (height / total * 100) if total else 0
    ax.text(
        bar.get_x() + bar.get_width()/2,
        height + 2,
        f"{height}",
        ha='center',
        fontsize=11,
        weight='bold'
    )
    ax.text(
        bar.get_x() + bar.get_width()/2, 2,
        f"{pct:.0f}%",
        ha='center',
        color="white",
        fontsize=10,
        weight='bold'
    )

plt.tight_layout()
plt.savefig("html_size_modern.png", dpi=220)
plt.show()