#include <WiFi.h>

#include "time.h"

const char* ssid = "abc";
const char* password = "12345678";

unsigned long lastTime = 0;
unsigned long timerDelay = 60000;

const char* ntpServer = "pool.ntp.org";
const char* tzInfo = "CET-1CEST,M3.5.0/2,M10.5.0/3";

char deTimeStr[25];
char usTimeStr[25];

void setup() {
  Serial.begin(9600);

  Serial.print("Verbinde mit WiFi ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nVerbunden!");
  Serial.print("IP Adresse: ");
  Serial.println(WiFi.localIP());

  configTzTime(tzInfo, ntpServer);
  printTimestamp();
}

void loop() {
  if ((millis() - lastTime) > timerDelay) {
    printTimestamp();
    lastTime = millis();
  }
}

void printTimestamp() {
  struct tm timeinfo;
  if (!getLocalTime(&timeinfo)) {
    Serial.println("Failed to obtain time");
    return;
  }

  strftime(deTimeStr, sizeof(deTimeStr), "%d.%m.%Y - %H:%M", &timeinfo);
  strftime(usTimeStr, sizeof(usTimeStr), "%Y-%m-%d - %H:%M", &timeinfo);

  Serial.println(deTimeStr);
  Serial.println(usTimeStr);
}