#include <ArduinoJson.h>
#include <ArduinoJson.hpp>

#include <WiFi.h>
#include <HTTPClient.h>

const char* ssid = "abc";
const char* password = "12345678";

String metalApiUrl = "https://api.edelmetalle.de/public.json";

unsigned long lastTime = 0;
unsigned long timerDelay = 300000;

void setup() {
  Serial.begin(9600);

  Serial.print("Verbinde mit WiFi ");
  Serial.println(ssid);

  WiFi.begin(ssid, password);

  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nVerbunden!");
  Serial.print("IP Adresse: ");
  Serial.println(WiFi.localIP());

  loadData();
}

void loop() {
  if ((millis() - lastTime) > timerDelay) {
    loadData();
    lastTime = millis();
  }
}

void loadData() {
  if (WiFi.status() == WL_CONNECTED) {
    HTTPClient http;
    http.begin(metalApiUrl.c_str());
    int httpResponseCode = http.GET();

    if (httpResponseCode == 200) {
      String payload = http.getString();
      handleJsonPayload(payload);
    } else if (httpResponseCode == 304) {
      Serial.println("Keine neuen Daten!");
    } else {
      Serial.print("HTTP Error: ");
      Serial.println(httpResponseCode);
    }
    http.end();

  } else {
    Serial.println("WiFi nicht verbunden – kein Refresh möglich.");
  }
}

void handleJsonPayload(String json) {
  Serial.println(json);

  StaticJsonDocument<400> doc;
  DeserializationError error = deserializeJson(doc, json);

  if (error) {
    Serial.print(F("deserializeJson() failed: "));
    Serial.println(error.f_str());
    return;
  }

  // USD Werte
  double gold_usd = doc["gold_usd"];
  double silber_usd = doc["silber_usd"];
  double platin_usd = doc["platin_usd"];
  double palladium_usd = doc["palladium_usd"];

  // EUR Werte
  double gold_eur = doc["gold_eur"];
  double silber_eur = doc["silber_eur"];
  double platin_eur = doc["platin_eur"];
  double palladium_eur = doc["palladium_eur"];
}