#include <lvgl.h>
#include <TFT_eSPI.h>

#define TFT_HOR_RES 240
#define TFT_VER_RES 320
#define TFT_ROTATION LV_DISPLAY_ROTATION_270

#define DRAW_BUF_SIZE (TFT_HOR_RES * TFT_VER_RES / 10 * (LV_COLOR_DEPTH / 8))
uint32_t draw_buf[DRAW_BUF_SIZE / 4];

#define COLOR_BG lv_color_hex(0x000000)
#define COLOR_RED lv_color_hex(0xE53935)
#define COLOR_GREEN lv_color_hex(0x43A047)
#define COLOR_BLUE lv_color_hex(0x1E88E5)
#define COLOR_ORANGE lv_color_hex(0xFB8C00)
#define COLOR_PURPLE lv_color_hex(0x8E24AA)
#define COLOR_CYAN lv_color_hex(0x00ACC1)
#define COLOR_YELLOW lv_color_hex(0xFDD835)
#define COLOR_PINK lv_color_hex(0xD81B60)

void setup() {
  Serial.begin(9600);
  lv_init();
  lv_display_t *disp = lv_tft_espi_create(TFT_HOR_RES, TFT_VER_RES, draw_buf, sizeof(draw_buf));
  lv_display_set_rotation(disp, TFT_ROTATION);

  lv_obj_t *scr = lv_screen_active();
  lv_obj_set_style_bg_color(scr, COLOR_BG, 0);
  lv_obj_set_style_bg_opa(scr, LV_OPA_COVER, 0);
  lv_obj_set_style_pad_all(scr, 12, 0);
  lv_obj_set_scrollbar_mode(scr, LV_SCROLLBAR_MODE_OFF);

  for (int index = 0; index < 8; index++) {
    lv_color_t color = COLOR_RED;
    const lv_font_t *font = &lv_font_montserrat_8;
    switch (index) {
      case 0:
        color = COLOR_RED;
        font = &lv_font_montserrat_8;
        break;
      case 1:
        color = COLOR_GREEN;
        font = &lv_font_montserrat_10;
        break;
      case 2:
        color = COLOR_BLUE;
        font = &lv_font_montserrat_12;
        break;
      case 3:
        color = COLOR_ORANGE;
        font = &lv_font_montserrat_14;
        break;
      case 4:
        color = COLOR_PURPLE;
        font = &lv_font_montserrat_16;
        break;
      case 5:
        color = COLOR_CYAN;
        font = &lv_font_montserrat_18;
        break;
      case 6:
        color = COLOR_YELLOW;
        font = &lv_font_montserrat_20;
        break;
      case 7:
        color = COLOR_PINK;
        font = &lv_font_montserrat_22;
        break;
    }
    Serial.println(index);
    createLabel(scr, color, font, index);
  }
}

static lv_obj_t *createLabel(lv_obj_t *screen, lv_color_t color, const lv_font_t *font, int index) {
  lv_obj_t *lbl = lv_label_create(screen);
  lv_label_set_text(lbl, "Hallo Welt!");
  lv_obj_set_style_text_color(lbl, color, 0);
  lv_obj_set_style_text_font(lbl, font, 0);

  int line_height = font->line_height;
  int y_offset = index * (line_height + 3);
  lv_obj_align(lbl, LV_ALIGN_TOP_MID, 0, y_offset);
  return lbl;
}

void loop() {
  lv_timer_handler();
  lv_tick_inc(5);
  delay(5);
}
