/*******************************************************
 *  Arduino Nesso N1 – Bildanzeige aus PROGMEM
 *  ---------------------------------------------------
 *  Dieses Beispiel zeigt, wie ein JPG-Bild direkt aus 
 *  dem Flash-Speicher (PROGMEM) geladen und auf dem 
 *  Display des Arduino Nesso N1 dargestellt wird.
 *
 *  Das Bild befindet sich in der Datei "bild.h" und 
 *  wurde zuvor über ein C-Array-Konvertierungstool 
 *  (z. B. FileToCArray) erzeugt.
 *
 *  Autor: Stefan Draeger
 *  Blogbeitrag:
 *  https://draeger-it.blog/arduino-nesso-n1-so-einfach-zeigst-du-eigene-bilder-auf-dem-display-an/
 *
 *  Hardware:
 *  - Arduino Nesso N1 (ESP32-C6)
 *  - Integriertes 240×135 SPI-Display (ST7789)
 *
 *  Benötigte Libraries:
 *  - M5GFX (Displaytreiber)
 *
 *  Dieses Beispiel zeigt nur ein statisches Standbild.
 *  Animationen oder das Laden aus dem Dateisystem
 *  werden in einem separaten Beitrag behandelt.
 *******************************************************/

#include <Arduino.h>
#include <M5GFX.h>
#include "bild.h"      // enthält: const uint8_t jpg[] PROGMEM

M5GFX display;          // Display-Objekt des Nesso N1

void setup() {
  display.begin();      // Display initialisieren

  display.setRotation(1); 
  // Dreht das Display ins Querformat
  // 0 = Hochformat, 1 = Querformat, 2/3 = invertiert

  display.fillScreen(TFT_BLACK); 
  // Hintergrund löschen, damit kein Artefakt sichtbar ist

  // JPG direkt aus PROGMEM anzeigen
  // Parameter:
  // 1) jpg         -> Byte-Array aus bild.h
  // 2) sizeof(jpg) -> Bildgröße in Bytes
  // 3) X-Position  -> 0
  // 4) Y-Position  -> 0
  display.drawJpg(jpg, sizeof(jpg), 0, 0);
}

void loop() {
  // Keine Aktion notwendig – das Bild bleibt stehen
}
