#include <M5GFX.h>

M5GFX display;

// PIN, den wir abfragen wollen
const char CORRECT_PIN[] = "1234";


// Hier speichern wir, was der Benutzer eingibt (max. 4 Stellen + '\0')
char enteredPin[5] = "";
int pinLen = 0;

// Bildschirmgröße (bei setRotation(1))
const int SCREEN_W = 240;
const int SCREEN_H = 135;

int buttonHeight = 35;

// Hilfsfunktion: gesamte Oberfläche neu zeichnen
void drawScreen() {
  display.fillScreen(TFT_BLACK);

  // Zahlen-Tasten zeichnen (0-4 oben, 5-9 unten)
  display.setTextColor(TFT_WHITE, TFT_BLACK);
  display.setTextSize(1);

  int buttonWidth = SCREEN_W / 5;  // 240 / 5 = 48
  
  // Zahlen-Tasten zeichnen (0-4 oben)
  display.setTextColor(TFT_WHITE, TFT_BLACK);
  display.setTextSize(2);  // kleine Schrift

  // Erste Reihe: 0-4
  int y1 = 15;
  for (int i = 0; i < 5; i++) {
    int x = i * buttonWidth;
    display.drawRect(x + 2, y1, buttonWidth - 4, buttonHeight, TFT_DARKGREY);

    display.setTextDatum(MC_DATUM);
    display.drawString(String(i), x + buttonWidth / 2, y1 + buttonHeight / 2);
  }

  // Zweite Reihe: 5-9
  int y2 = 15 + buttonHeight + 10;
  for (int i = 0; i < 5; i++) {
    int x = i * buttonWidth;
    int num = i + 5;

    display.drawRect(x + 2, y2, buttonWidth - 4, buttonHeight, TFT_DARKGREY);

    display.setTextDatum(MC_DATUM);
    display.drawString(String(num), x + buttonWidth / 2, y2 + buttonHeight / 2);
  }


  // Eingabe-Feld links unten
  display.setTextDatum(ML_DATUM);
  display.drawRect(2, SCREEN_H - 35, 140, 25, TFT_DARKGREY);
  display.setTextColor(TFT_CYAN, TFT_BLACK);
  display.drawString(String(enteredPin), 15, SCREEN_H - 23);

  // OK-Button rechts unten
  int okW = 60;
  int okH = 25;
  int okX = SCREEN_W - okW - 10;
  int okY = SCREEN_H - okH - 10;

  display.fillRect(okX, okY, okW, okH, TFT_DARKGREEN);
  display.setTextColor(TFT_BLACK, TFT_DARKGREEN);
  display.setTextDatum(MC_DATUM);
  display.drawString("OK", okX + okW / 2, okY + okH / 2);
}

// Hilfsfunktion: PIN zurücksetzen
void resetPin() {
  pinLen = 0;
  enteredPin[0] = '\0';
}

// Prüfen, ob PIN korrekt ist
void checkPin() {
  display.setTextDatum(MC_DATUM);
  display.setTextSize(2);

  if (pinLen == 4 && strcmp(enteredPin, CORRECT_PIN) == 0) {
    display.setTextColor(TFT_GREEN, TFT_BLACK);
    display.drawString("Zugang erlaubt", SCREEN_W / 2, SCREEN_H / 2);
    beep(true);
    delay(2000);
  } else {
    display.setTextColor(TFT_RED, TFT_BLACK);
    display.drawString("Falscher PIN", SCREEN_W / 2, SCREEN_H / 2);
    beep(false);
    delay(2000);
  }

  delay(1000);
  resetPin();
  drawScreen();
}

void beep(bool ok) {
  for (int i = 0; i < 6; i++) {
    tone(BEEP_PIN, ok ? 850 : 600, 500);
    delay(125);
  }
}


// Zahl zur Eingabe hinzufügen
void addDigit(int digit) {
  if (pinLen >= 4) {
    return;  // maximal 4 Stellen
  }

  enteredPin[pinLen] = '0' + digit;
  pinLen++;
  enteredPin[pinLen] = '\0';

  // Nur das Eingabefeld neu zeichnen
  display.setTextDatum(ML_DATUM);
  display.setTextColor(TFT_CYAN, TFT_BLACK);
  display.fillRect(11, SCREEN_H - 34, 118, 23, TFT_BLACK);  // Feld leeren
  display.drawString(String(enteredPin), 15, SCREEN_H - 23);
}

void setup() {
  display.begin();
  display.setRotation(1);  // Querformat
  drawScreen();
}

void loop() {
  lgfx::touch_point_t tp;

  if (display.getTouch(&tp)) {
    int x = tp.x;
    int y = tp.y;

    int buttonWidth = SCREEN_W / 5;

    // OK-Button-Koordinaten berechnen
    int okW = 60;
    int okH = 25;
    int okX = SCREEN_W - okW - 10;
    int okY = SCREEN_H - okH - 10;

    // Wurde der OK-Button gedrückt?
    if (x >= okX && x <= okX + okW && y >= okY && y <= okY + okH) {
      checkPin();
      delay(200);  // einfache Entprellung
      return;
    }

    // Erste Zahlenreihe (0-4): y zwischen 30 und 30+buttonHeight
    if (y >= 30 && y <= 30 + buttonHeight) {
      int col = x / buttonWidth;  // 0..4
      if (col >= 0 && col <= 4) {
        int digit = col;  // 0..4
        addDigit(digit);
      }
    }

    // Zweite Zahlenreihe (5-9): y zwischen y2 und y2+buttonHeight
    int y2 = 30 + buttonHeight + 10;
    if (y >= y2 && y <= y2 + buttonHeight) {
      int col = x / buttonWidth;  // 0..4
      if (col >= 0 && col <= 4) {
        int digit = col + 5;  // 5..9
        addDigit(digit);
      }
    }

    // einfache Touch-Entprellung
    delay(200);
  }

  delay(10);
}
